<?php
//
// (C) egate media GmbH 2014
//


class emitrecht_oxEmail extends emitrecht_oxEmail_parent
{

    public function sendOrderEmailToUser($oOrder, $sSubject = null)
    {
        // EM: OXID standard function except the block at end of source

        $myConfig = $this->getConfig();

        // add user defined stuff if there is any
        $oOrder = $this->_addUserInfoOrderEMail( $oOrder );

        $oShop = $this->_getShop();
        $this->_setMailParams( $oShop );

        $oUser = $oOrder->getOrderUser();
        $this->setUser( $oUser );

        // create messages
        $oSmarty = $this->_getSmarty();
        $this->setViewData( "order", $oOrder);

        if ( $myConfig->getConfigParam( "bl_perfLoadReviews" ) ) {
            $this->setViewData( "blShowReviewLink", true );
        }

        // Process view data array through oxoutput processor
        $this->_processViewArray();

        $this->setBody( $oSmarty->fetch( $this->_sOrderUserTemplate ) );
        $this->setAltBody( $oSmarty->fetch( $this->_sOrderUserPlainTemplate ) );

        // #586A
        if ( $sSubject === null ) {
            if ( $oSmarty->template_exists( $this->_sOrderUserSubjectTemplate) ) {
                $sSubject = $oSmarty->fetch( $this->_sOrderUserSubjectTemplate );
            } else {
                $sSubject = $oShop->oxshops__oxordersubject->getRawValue()." (#".$oOrder->oxorder__oxordernr->value.")";
            }
        }

        $this->setSubject( $sSubject );

        $sFullName = $oUser->oxuser__oxfname->getRawValue() . " " . $oUser->oxuser__oxlname->getRawValue();

        $this->setRecipient( $oUser->oxuser__oxusername->value, $sFullName );
        $this->setReplyTo( $oShop->oxshops__oxorderemail->value, $oShop->oxshops__oxname->getRawValue() );


        // EM start
        $oLang = oxLang::getInstance();
        $sAbbr = $oLang->getLanguageAbbr($oLang->getBaseLanguage());
        if ($sAbbr == "de")
        {
            $sShopId = $this->getConfig()->getShopId();
            if (is_numeric($sShopId))
            {
                $sFileShopId = '_'.intval($sShopId);
            }
            else
            {
                $sFileShopId = '';
            }
            if ($myConfig->getShopConfVar("itrecht_blAttachAGB"))
            {
                $sAttFile     = 'agb'.$sFileShopId.'.pdf';
                $sAttFullPath = getShopBasePath().'modules/emitrecht/pdf/'.$sAttFile;
                $this->addAttachment($sAttFullPath, $sAttFile);
            }
            if ($myConfig->getShopConfVar("itrecht_blAttachWithdrawal"))
            {
                $sAttFile     = 'widerruf'.$sFileShopId.'.pdf';
                $sAttFullPath = getShopBasePath().'modules/emitrecht/pdf/'.$sAttFile;
                $this->addAttachment($sAttFullPath, $sAttFile);
            }
        }
        // EM end

        $blSuccess = $this->send();

        return $blSuccess;
    }
}
?>