<?php
/* --------------------------------------------------------------
	itrecht_installer.php 2014 gm
	Gambio GmbH
	http://www.gambio.de
	Copyright (c) 2014 Gambio GmbH
	Released under the GNU General Public License (Version 2)
	[http://www.gnu.org/licenses/gpl-2.0.html]
	--------------------------------------------------------------
*/

require 'includes/application_top.php';
header('Content-Type: text/plain');

if(!(isset($_SESSION['customers_status']['customers_status_id']) && $_SESSION['customers_status']['customers_status_id'] == 0)) {
	die('unauthorized');
}

$sql = array();
$dirs = array();
$fileperms = array();
$orders_status = array();

/* ================================================================================================= */


$admin_access = array('itrecht_config');


/* ================================================================================================= */


function addOrdersStatus($orders_status_id, $statusname, $language_id) {
	if(($insert_id = ordersStatusExists($statusname, $language_id)) === false) {
		xtc_db_query("INSERT INTO orders_status (orders_status_id, language_id, orders_status_name) VALUES (".(int)$orders_status_id.", ".(int)$language_id.", '".$statusname."')");
		$insert_id = xtc_db_insert_id();
	}
	return $insert_id;
}

function ordersStatusExists($statusname, $language_id) {
	$query = "SELECT orders_status_id FROM orders_status WHERE language_id = ".(int)$language_id." AND orders_status_name LIKE '%".$statusname."%'";
	$result = xtc_db_query($query);
	$orders_status_id = false;
	while($row = xtc_db_fetch_array($result)) {
		$orders_status_id = $row['orders_status_id'];
	}
	return $orders_status_id;
}

function findNextOrdersStatusId() {
	$query = "SELECT ((FLOOR(MAX(orders_status_id) / 10) + 1) * 10) AS next_id FROM `orders_status`";
	$result = xtc_db_query($query);
	$row = xtc_db_fetch_array($result);
	return $row['next_id'];
}


function addAdminAccess($entity, $allow_all = true) {
	$col_exists_query = "show columns from admin_access like ':colname'";
	$col_exists_query = strtr($col_exists_query, array(':colname' => $entity));
	$ce_result = xtc_db_query($col_exists_query);
	if(xtc_db_num_rows($ce_result) > 0) {
		// columns already exists, don't do anything
		return false;
	}
	$add_col_query = "ALTER TABLE `admin_access` ADD `:colname` INT( 1 ) NOT NULL DEFAULT '0';";
	$add_col_query = strtr($add_col_query, array(':colname' => $entity));
	xtc_db_query($add_col_query);
	if($allow_all) {
		$allow_query = "UPDATE admin_access SET `:colname` = 1;";
		$allow_query = strtr($allow_query, array(':colname' => $entity));
		xtc_db_query($allow_query);
	}
	return true;
}


if(!empty($sql)) {
	echo "Fuehre Datenbankanpassungen durch ...\n";
	foreach($sql as $query) {
		xtc_db_query($query);
	}
}

if(!empty($admin_access)) {
	echo "Erzeuge neue Admin-Rechte ...\n";
	foreach($admin_access as $entity) {
		addAdminAccess($entity);
  }
}

if(!empty($orders_status)) {
	echo "Lege Bestellstatus an ...\n";
	$next_id = findNextOrdersStatusId();
	foreach($orders_status as $os) {
		foreach($os as $lang_id => $osname) {
			addOrdersStatus($next_id, $osname, $lang_id);
		}
		$next_id++;
	}
}


if(!empty($dirs)) {
	echo "Erzeuge Verzeichnisse ...\n";
	foreach($dirs as $dirdata) {
		if(!is_dir($dirdata['dirname'])) {
			$dir_made = mkdir($dirdata['dirname'], $dirdata['mode'], $dirdata['recursive']);
			if($dir_made !== true) {
				echo "FEHLER: ". $dirdata['dirname'] ." konnte nicht erzeugt werden!\n";
			}
		}
	}
}

if(!empty($fileperms)) {
	echo "Ueberpruefe Datei-/Verzeichnisrechte ...\n";
	foreach($fileperms as $fp) {
		if($fp['access'] == 'write') {
			if(is_writeable($fp['file'])) {
				echo $fp['file'] . " - OK\n";
			}
			else {
				echo $fp['file'] ." - FEHLER: muss beschreibbar sein!\n";
			}
		}
	}
}

echo "\n\nFertig.\n";
